//---------------------------------------------------------------------------


#pragma hdrstop

#include "Drukowanie.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)


int Drukuj(TStrings* tekst,TFont* czcionka,bool domyslnaDrukarka,AnsiString tytul,TMarginesy marginesy)
{
   //const int marginesLewy=1000,marginesPrawy=1000,marginesGorny=1000,marginesDolny=1000;

   if (!domyslnaDrukarka)
   {
	  TPrintDialog* PrintDialog=new TPrintDialog(NULL);
      bool wynik=PrintDialog->Execute();
      delete PrintDialog;
      if (!wynik) return 0;
   }

   TPrinter* Drukarka=Printer();
   Drukarka->Title=tytul;
   //Ustawianie wielkosci czcionki
   Drukarka->Canvas->Font=czcionka;

   //Ustalanie wysokosci wiersza na wydruku na podstawie wielkosci czcionki
   int wysokoscCzcionki=Drukarka->Canvas->TextHeight('A');
   for(int i=0;i<tekst->Count;i++)
      if (Drukarka->Canvas->TextHeight(tekst->Strings[i])>wysokoscCzcionki)
         wysokoscCzcionki=Drukarka->Canvas->TextHeight(tekst->Strings[i]);

   //Wysokosc linii to poltora wysokosci najwyzszej czcionki
   int wysokoscLinii=(3*wysokoscCzcionki)/2;

   //ustalanie koloru tekstu
   Drukarka->Canvas->Pen->Color=czcionka->Color;

   //lamanie dlugich linii
   int szerokoscStrony=Drukarka->PageWidth-marginesy.Lewy-marginesy.Prawy;
   for(int i=0;i<tekst->Count;i++)
      if (Drukarka->Canvas->TextWidth(tekst->Strings[i])>szerokoscStrony)
         ShowMessage("Linia "+IntToStr(i)+" jest dusza ni szeroko strony");

   Drukarka->BeginDoc();
   int linia=0;
   int strona=1;
   for(int i=0;i<tekst->Count;i++)
   {
	  Drukarka->Canvas->TextOut(marginesy.Lewy,marginesy.Gorny+linia*wysokoscLinii,tekst->Strings[i]);
      linia++;
	  if ((marginesy.Gorny+linia*wysokoscLinii)>=(Drukarka->PageHeight-marginesy.Dolny))
	  {
		 linia=0;
		 Drukarka->NewPage();
		 strona++;
	  }
   }
   Drukarka->EndDoc();
   return strona;
}

void Drukuj(TGraphic* obraz,bool zachowajProporcje,bool domyslnaDrukarka,AnsiString tytul,TMarginesy marginesy)
{
   //const int marginesLewy=1000,marginesPrawy=1000,marginesGorny=1000,marginesDolny=1000;

   if (!domyslnaDrukarka)
   {
	  TPrintDialog* PrintDialog=new TPrintDialog(NULL);
	  bool wynik=PrintDialog->Execute();
	  delete PrintDialog;
	  if (!wynik) return;
   }

   TPrinter* Drukarka=Printer();
   Drukarka->Title=tytul;

   float proporcjeObrazu=obraz->Width/(float)obraz->Height;

   //portret/pejzaz
   if (proporcjeObrazu<1) Drukarka->Orientation=poPortrait;
   else Drukarka->Orientation=poLandscape;

   //wstepny obszar to cala strona poza marginesami
   TRect obszar;
   obszar.Left=marginesy.Lewy;
   obszar.Right=Drukarka->PageWidth-marginesy.Prawy;
   obszar.Top=marginesy.Gorny;
   obszar.Bottom=Drukarka->PageHeight-marginesy.Dolny;
   float proporcjeObszaru=(obszar.Right-obszar.Left)/(float)(obszar.Bottom-obszar.Top);

   //skalowanie
   if (zachowajProporcje)
   {
	  if (proporcjeObrazu>proporcjeObszaru)
		 obszar.Bottom=obszar.Top+(int)((obszar.Right-obszar.Left)/proporcjeObrazu);
	  else
		 obszar.Right=obszar.Left+(int)((obszar.Bottom-obszar.Top)*proporcjeObrazu);
   }

   //drukowanie
   Drukarka->BeginDoc();
   Drukarka->Canvas->TextOut(0,0,""); //wymuszenie przygotowania plotna
   Drukarka->Canvas->StretchDraw(obszar,obraz);
   Drukarka->EndDoc();
}

